/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.AbstractInput;
import de.willuhn.jameica.gui.internal.swt.PopupList;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SearchInput
extends AbstractInput {
    public static final int DEFAULT_DELAY = 1000;
    private String attribute = null;
    private Object value = null;
    private Text text = null;
    private boolean enabled = true;
    private String search = null;
    private boolean focus = false;
    private int maxLength = 0;
    private int startAt = 1;
    private int minWidth = 0;
    private List<Listener> listeners = new ArrayList<Listener>();
    private int delay = 1000;
    private boolean inSearch = false;

    public SearchInput() {
        this.search = Application.getI18n().tr("Suche...");
    }

    public void setSearchString(String text) {
        if (text != null) {
            this.search = text;
        }
    }

    public void setAttribute(String name) {
        if (name != null) {
            this.attribute = name;
        }
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setTextLimit(this.maxLength);
        }
    }

    public void setStartAt(int length) {
        if (length > 0) {
            this.startAt = length;
        }
    }

    public void setMinWidth(int width) {
        if (width >= 0) {
            this.minWidth = width;
        }
    }

    public void setDelay(int millis) {
        if (millis > 0) {
            this.delay = millis;
        }
    }

    private void setList(List list) {
        if (this.inSearch || this.text == null || this.text.isDisposed()) {
            return;
        }
        if (list == null || list.size() == 0) {
            return;
        }
        try {
            ArrayList<String> items = new ArrayList<String>();
            ArrayList values = new ArrayList();
            for (Object object : list) {
                String text;
                if (object == null || (text = this.format(object)) == null) continue;
                items.add(text);
                values.add(object);
            }
            Point location = this.text.toDisplay(this.text.getLocation());
            Rectangle rect = this.text.getClientArea();
            PopupList popup = new PopupList(GUI.getShell());
            popup.setItems(items.toArray(new String[items.size()]));
            popup.setMinimumWidth(this.minWidth);
            int selected = popup.open(new Rectangle(location.x, rect.y + location.y + rect.height, rect.width, 0));
            if (selected >= 0) {
                this.setValue(values.get(selected));
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to create combo box", (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Laden der Daten..."), 1));
        }
    }

    protected String format(Object bean) {
        if (bean == null) {
            return null;
        }
        try {
            if (this.attribute == null || this.attribute.length() == 0) {
                return BeanUtil.toString((Object)bean);
            }
            Object value = BeanUtil.get((Object)bean, (String)this.attribute);
            return value == null ? null : value.toString();
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to format object", (Throwable)re);
            return null;
        }
    }

    public List startSearch(String text) {
        return null;
    }

    @Override
    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    @Override
    public Control getControl() {
        String display;
        if (this.text != null && !this.text.isDisposed()) {
            return this.text;
        }
        this.text = GUI.getStyleFactory().createText(this.getParent());
        Object tooltip = this.getData("datakey.tooltip");
        if (tooltip != null) {
            this.text.setToolTipText(tooltip.toString());
        }
        String string = display = this.value == null ? null : this.format(this.value);
        if (display == null) {
            display = this.search;
        }
        if (this.value == null && this.focus) {
            display = "";
        }
        this.text.setText(display);
        if (!this.focus && this.value == null || !this.enabled) {
            this.text.setForeground(de.willuhn.jameica.gui.util.Color.COMMENT.getSWTColor());
        }
        this.text.setEnabled(this.enabled);
        this.text.setEditable(this.enabled);
        if (this.maxLength > 0) {
            this.text.setTextLimit(this.maxLength);
        }
        Listener focusIn = new Listener(){

            public void handleEvent(Event event) {
                if (SearchInput.this.text == null || SearchInput.this.text.isDisposed()) {
                    return;
                }
                String s = SearchInput.this.text.getText();
                if (s != null && s.equals(SearchInput.this.search)) {
                    SearchInput.this.text.setText("");
                    SearchInput.this.text.setForeground(de.willuhn.jameica.gui.util.Color.FOREGROUND.getSWTColor());
                }
            }
        };
        this.text.addListener(4, focusIn);
        this.text.addListener(15, focusIn);
        this.text.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (SearchInput.this.text == null || SearchInput.this.text.isDisposed()) {
                    return;
                }
                String s = SearchInput.this.text.getText();
                if (s == null || s.length() == 0) {
                    SearchInput.this.text.setText(SearchInput.this.search);
                    SearchInput.this.text.setForeground(de.willuhn.jameica.gui.util.Color.COMMENT.getSWTColor());
                }
            }
        });
        if (this.focus) {
            this.text.setFocus();
        }
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (SearchInput.this.text == null || SearchInput.this.text.isDisposed()) {
                    return;
                }
                if (event.keyCode == 27) {
                    return;
                }
                if (SearchInput.this.inSearch) {
                    SearchInput.this.inSearch = false;
                    return;
                }
                String newText = SearchInput.this.text.getText();
                if (newText == null || newText.length() <= SearchInput.this.startAt) {
                    return;
                }
                if (newText.equals(SearchInput.this.search)) {
                    return;
                }
                List newList = SearchInput.this.startSearch(newText);
                SearchInput.this.setList(newList);
            }
        };
        this.text.addListener(2, (Listener)new DelayedListener(this.delay, listener));
        this.text.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    listener.handleEvent(event);
                }
            }
        });
        return this.text;
    }

    @Override
    public Object getValue() {
        if (this.text == null || this.text.isDisposed()) {
            return this.value;
        }
        String s = this.text.getText();
        if (s == null || s.length() == 0 || s.equals(this.search)) {
            return null;
        }
        return this.value;
    }

    public String getText() {
        if (this.text == null || this.text.isDisposed()) {
            return null;
        }
        String s = this.text.getText();
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.equals(this.search)) {
            return null;
        }
        return s;
    }

    public void setText(String s) {
        if (s != null && this.text != null && !this.text.isDisposed()) {
            this.text.setText("");
            this.text.insert(s);
        }
    }

    @Override
    public void focus() {
        this.focus = true;
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setFocus();
        }
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setEnabled(enabled);
            this.text.setEditable(enabled);
            if (enabled) {
                this.text.setForeground(de.willuhn.jameica.gui.util.Color.FOREGROUND.getSWTColor());
            } else {
                this.text.setForeground(de.willuhn.jameica.gui.util.Color.COMMENT.getSWTColor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object o) {
        this.value = o;
        if (this.text != null && !this.text.isDisposed()) {
            try {
                this.inSearch = true;
                String s = this.format(this.value);
                this.text.setText(s == null ? "" : s);
                if (s != null && !s.equals(this.search)) {
                    this.text.setForeground(de.willuhn.jameica.gui.util.Color.FOREGROUND.getSWTColor());
                }
                if (this.listeners.size() > 0) {
                    Event e = new Event();
                    e.data = this.value;
                    e.text = s;
                    for (Listener l : this.listeners) {
                        l.handleEvent(e);
                    }
                }
            }
            finally {
                this.inSearch = false;
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void update() throws OperationCanceledException {
        super.update();
        if (this.text == null || this.text.isDisposed()) {
            return;
        }
        String s = this.text.getText();
        Color color = null;
        if (this.isMandatory() && (s == null || s.length() == 0 || s.equals(this.search))) {
            color = de.willuhn.jameica.gui.util.Color.MANDATORY_BG.getSWTColor();
        }
        this.text.setBackground(color);
    }
}

